DECLARE iHour   INT; 
DECLARE iMinute INT; 
DECLARE iSecond INT; 
DECLARE iYear   INT; 
DECLARE iMonth  INT; 
DECLARE iDay    INT; 

SET iHour   = EXTRACT( HOUR FROM CURRENT_TIME ); 
SET iMinute = EXTRACT( MINUTE FROM CURRENT_TIME ); 
SET iSecond = CAST( EXTRACT( SECOND FROM CURRENT_TIME ) AS INT );
SET iYear   = EXTRACT( YEAR FROM CURRENT_DATE );
SET iMonth  = EXTRACT( MONTH FROM CURRENT_DATE );
SET iDay    = EXTRACT( DAY FROM CURRENT_DATE ); 

SELECT 
  CAST( CURRENT_USER AS VARCHAR(15) ) AS Gebruiker, 
  CAST( CASE WHEN ( iHour   <  10 ) THEN  '0' ELSE '' END || TOSTRING( iHour )   ||':'||  
        CASE WHEN ( iMinute <  10 ) THEN  '0' ELSE '' END || TOSTRING( iMinute ) ||':'||  
        CASE WHEN ( iSecond <  10 ) THEN  '0' ELSE '' END || TOSTRING( iSecond ) AS VARCHAR(10) ) AS Tijd,              
  CAST( CASE WHEN ( iDay    <  10 ) THEN  '0' ELSE '' END || TOSTRING( iDay )    ||'-'||    
        CASE WHEN ( iMonth  <  10 ) THEN  '0' ELSE '' END || TOSTRING( iMonth )  ||'-'||    
        CASE WHEN ( iYear   < 100 ) THEN '20' ELSE '' END || TOSTRING( iYear ) AS VARCHAR(10) ) AS Datum  
FROM #DUMMY;